clear all, close all

% experimental parameters
nop_v = 25; % no. of data points per voltage
concentration = [0.01 0.1 1];

% general directory
directory = 'D:\Dropbox\Desalination\Figures for the manuscript\Data for IV-plots\';

% chip13_0.01mMNaCl_3uLmin
experiments1 = {'chip13_0.01mMNaCl_3uLmin_2','chip13_0.01mMNaCl_3uLmin_3','chip13_0.01mMNaCl_3uLmin_4'};
% chip13_0.1mMNaCl_3uLmin
experiments2 = {'chip13_0.1mMNaCl_3uLmin_16','chip13_0.1mMNaCl_3uLmin_17'};
% chip13_1mMNaCl_3uLmin
experiments3 = {'chip13_1mMNaCl_3uLmin_25','chip13_1mMNaCl_3uLmin_26'};
% append
experiments = {experiments1; experiments2; experiments3};

sets_exp = length(experiments);

for p = 1:sets_exp
    
%     U = [];
%     I = [];
%     t = [];
    
    for q = 1:length(experiments{p})
        folder = [directory experiments{p}{q}];
        [U{p}(q,:),I{p}(q,:),t{p}(q,:)] = read_data_keithley(folder,0);
    end
    
    for r = 1:length(U{p}(1,:))/nop_v
        indices = (r-1)*nop_v+1:r*nop_v;
        U_selec = U{p}(:,indices);
        I_selec = I{p}(:,indices);
        Umean(p,r) = mean(U_selec(:));
        Ustd(p,r) = std(U_selec(:));
        Imean(p,r) = mean(I_selec(:));
        Istd(p,r) = std(I_selec(:));
    end

end

% normalize Imean and Istd
Inormalization = 10.^[-2:0];
for j = 1:sets_exp
Imean_max(j) = max(Imean(j,:));
Imean_norm(j,:) = Imean(j,:)./Imean_max(j);
Istd_norm(j,:) = Istd(j,:)./Imean_max(j);
% Imean_norm(j,:) = Imean(j,:)./Inormalization(j);
% Istd_norm(j,:) = Istd(j,:)./Inormalization(j);
end
%Istd_rel = Istd./Imean;

% compute derivatives
for p = 1:sets_exp
    dIdU(p,:) = gradient(Imean(p,:),Umean(p,:));
    dIdU_norm(p,:) = gradient(Imean_norm(p,:),Umean(p,:));
end

% plot figures
map = cbrewer('seq','OrRdBlGr',sets_exp);
symbols = {'*','x','.','o','s'};
nn = 0;

% plot normalised values on linear scale
nn = nn+1;
figure(nn)
hold on
plot([6 6],[0 0.75],'--k')
plot([22 22],[0 0.75],'--k')
for j = 1:sets_exp
    %H(j) = shadedErrorBar(Umean(j,:),1e6.*Imean(j,:),1e6.*Istd(j,:),{'color',map(j,:),'marker','*','LineStyle','-'});
    H(j) = shadedErrorBar(Umean(j,:),Imean_norm(j,:),Istd_norm(j,:),{'color',map(j,:),'marker',symbols{j},'LineStyle','-'});
    %lineProps.col{j} = map(j,:);
    legendentries{j} = [num2str(concentration(j)) ' mM NaCl, I_{max} = ' num2str(round(Imean_max(j)*1e6*100)/100) ' \muA'];
end
%mseb(Umean,Imean_norm,Istd_norm,lineProps);
hold off
box on
xlabel('\DeltaU (V)')
ylabel('I/I_{max}')
ylim([0 1.1])
xlim([0 50])
legend([H(1).mainLine,H(2).mainLine,H(3).mainLine],legendentries,'Location','NorthWest')
legend boxoff
title('(b) Normalized current I/I_{max} versus \DeltaU')
text(3,0.7,'Ohm.','HorizontalAlignment','center')
text(14,0.7,'Lim.','HorizontalAlignment','center')
text(27,0.7,'Over-lim.','HorizontalAlignment','center')
%set(gca,'yScale','log')
set(gcf,'color','w');
fig=gcf;
%set(findall(fig,'-property','FontSize'),'FontSize',13) 
%export_fig IVcurvechip13.png -m3
matlab2tikz('IVcurvechip13.tikz', 'height', '\figureheight', 'width', '\figurewidth');

% plot values on log-lin scale
nn = nn+1;
figure(nn)
hold on
for j = 1:sets_exp
    H(j) = shadedErrorBar(Umean(j,:),1e6.*Imean(j,:),1e6.*Istd(j,:),{'color',map(j,:),'marker',symbols{j},'LineStyle','-'});
    %H(j) = shadedErrorBar(Umean(j,:),Imean_norm(j,:),Istd_norm(j,:),{'color',map(j,:),'marker','.','LineStyle','-'});
    %lineProps.col{j} = map(j,:);
    legendentries{j} = [num2str(concentration(j)) ' mM NaCl'];
end
%mseb(Umean,Imean_norm,Istd_norm,lineProps);
hold off
box on
xlabel('\DeltaU (V)')
ylabel('I (\muA)')
title('(a) Absolute current I versus \DeltaU')
ylim([1e-3 1e1])
xlim([0 50])
legend([H(1).mainLine,H(2).mainLine,H(3).mainLine],legendentries,'Location','SouthEast')
legend boxoff
set(gca,'yScale','log')
set(gcf,'color','w');
fig=gcf;
%set(findall(fig,'-property','FontSize'),'FontSize',13) 
%export_fig IVcurvechip13log.png -m3
matlab2tikz('IVcurvechip13log.tikz', 'height', '\figureheight', 'width', '\figurewidth');

% plot derivatives - absolute values
nn = nn+1;
figure(nn)
hold on
for j = 1:sets_exp
    plot(Umean(j,:),1e6.*dIdU(j,:),'color',map(j,:),'marker',symbols{j},'LineStyle','-');
    legendentries{j} = [num2str(concentration(j)) ' mM NaCl'];
end
hold off
box on
xlim([0 50])
xlabel('\DeltaU (V)')
ylabel('dI/dU (\muA/V)')
legend(legendentries)
legend boxoff
set(gcf,'color','w');
fig=gcf;
%set(findall(fig,'-property','FontSize'),'FontSize',13) 
%export_fig dIdUcurvechip13.png -m3

% plot derivatives - normalized values
nn = nn+1;
figure(nn)
hold on
for j = 1:sets_exp
    plot(Umean(j,:),dIdU_norm(j,:),'color',map(j,:),'marker',symbols{j},'LineStyle','-');
    legendentries{j} = [num2str(concentration(j)) ' mM NaCl'];
end
hold off
box on
xlim([0 50])
xlabel('\DeltaU (V)')
ylabel('dI/dU (\muA/V)')
legend(legendentries)
legend boxoff

% plot relative currents
nn = nn+1;
figure(nn)
hold on
for j = 1:sets_exp
    plot(Umean(j,:),Imean(j,:)./Imean(1,:),'color',map(j,:),'marker',symbols{j},'LineStyle','-');
    legendentries{j} = [num2str(concentration(j)) ' mM NaCl'];
end
hold off
box on
xlim([0 50])
ylim([0.8e0 1e2])
set(gca,'yScale','log')
xlabel('\DeltaU (V)')
ylabel('I/I_{(0.01mM)}')
legend(legendentries)
legend boxoff
set(gcf,'color','w');
fig=gcf;
%set(findall(fig,'-property','FontSize'),'FontSize',13) 
%export_fig IoverI1curvechip13.png -m3